// XISLVarDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "ib.h"
#include "XISLVarDlg.h"
#include "XISLTag.h"
#include "XISLVar.h"
#include "XISLVarList.h"
#include "XISLExcItem.h"
#include "XISLDialogTag.h"
#include "XISLChangeVarDlg.h"
#include "XISLRootTag.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CXISLRootTag *g_pAppRootTag;
/////////////////////////////////////////////////////////////////////////////
// CXISLVarDlg _CAO


CXISLVarDlg::CXISLVarDlg(CXISLTag *pTag,CWnd* pParent /*=NULL*/)
	: CDialog(CXISLVarDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CXISLVarDlg)
	m_nScopeGlp = 3;
	m_strName = _T("");
	m_strExpr = _T("");
	//}}AFX_DATA_INIT
	m_pCurrentTag = pTag;
	m_pParentView = NULL;
}


void CXISLVarDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CXISLVarDlg)
	DDX_Control(pDX, IDC_LIST_VAR, m_lbVar);
	DDX_Radio(pDX, IDC_RADIO_APP, m_nScopeGlp);
	DDX_Text(pDX, IDC_EDIT_NAME, m_strName);
	DDX_Text(pDX, IDC_EDIT_EXPR, m_strExpr);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CXISLVarDlg, CDialog)
	//{{AFX_MSG_MAP(CXISLVarDlg)
	ON_BN_CLICKED(IDC_BUTTON_CHANGE, OnButtonChange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CXISLVarDlg bZ[W nh

BOOL CXISLVarDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	m_lbVar.SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);
	LVCOLUMNA column;
	column.mask = LVCF_TEXT|LVCF_WIDTH;

	RECT rect;
	m_lbVar.GetClientRect(&rect);
	column.cx = 50;
	column.pszText = "Scope";
	m_lbVar.InsertColumn(0,&column);

	column.cx = 70;
	column.pszText = "ϐ";
	m_lbVar.InsertColumn(1,&column);

	column.cx = (rect.right-rect.left)-120;
	column.pszText = "l";
	m_lbVar.InsertColumn(2,&column);

	GetDlgItem(IDC_RADIO_APP)->EnableWindow(FALSE);

	int nType = m_pCurrentTag->m_nTagType;
	if(nType == ID_TAG_XISL)
	{
		GetDlgItem(IDC_RADIO_LOCAL)->EnableWindow(FALSE);
		GetDlgItem(IDC_RADIO_DIA)->EnableWindow(FALSE);
		int nCount = ((CXISLRootTag*)m_pCurrentTag)->m_pDocumentVar->SetVar2ListBox(m_lbVar);
		if(!((CXISLRootTag*)m_pCurrentTag)->IsAppRoot() && g_pAppRootTag)
		{
			g_pAppRootTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
			m_nScopeGlp = 1;
		}
		else
		{
			GetDlgItem(IDC_RADIO_APP)->EnableWindow(TRUE);
			GetDlgItem(IDC_RADIO_DOC)->EnableWindow(FALSE);
			m_nScopeGlp = 0;
		}
	}
	else if(nType == ID_TAG_DIALOG)
	{
		GetDlgItem(IDC_RADIO_LOCAL)->EnableWindow(FALSE);
		int nCount = ((CXISLDialogTag*)m_pCurrentTag)->m_pDialogVar->SetVar2ListBox(m_lbVar);
		
		CXISLRootTag *pRTag = (CXISLRootTag*)m_pCurrentTag->GetRootTag();
		nCount = pRTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
		
		if(!pRTag->IsAppRoot() && g_pAppRootTag)
			g_pAppRootTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
		else
		{
			GetDlgItem(IDC_RADIO_APP)->EnableWindow(TRUE);
			GetDlgItem(IDC_RADIO_DOC)->EnableWindow(FALSE);
		}
		m_nScopeGlp = 2;
	}
	else if(nType == ID_TAG_EXCHANGE || nType == ID_TAG_BEGIN || nType == ID_TAG_END)
	{
		int nCount = ((CXISLExcItem*)m_pCurrentTag)->m_pLocalVar->SetVar2ListBox(m_lbVar);

		CXISLDialogTag *pDTag = (CXISLDialogTag*)m_pCurrentTag->GetParentDialogTag();
		nCount = pDTag->m_pDialogVar->SetVar2ListBox(m_lbVar,nCount);
		
		CXISLRootTag *pRTag = (CXISLRootTag*)pDTag->GetRootTag();
		nCount = pRTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
		
		if(!pRTag->IsAppRoot() && g_pAppRootTag)
			g_pAppRootTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
		else
		{
			GetDlgItem(IDC_RADIO_APP)->EnableWindow(TRUE);
			GetDlgItem(IDC_RADIO_DOC)->EnableWindow(FALSE);
		}
		m_nScopeGlp = 3;
	}

	UpdateData(FALSE);

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CXISLVarDlg::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	UpdateData();
	CXISLVar *pVar = new CXISLVar;
	if(pVar->SetAttribute(m_strName,m_strExpr) != 0)
	{
		delete pVar;
		return;
	}

	int nRet = 0;
	CXISLDialogTag *pDTag = NULL;
	CXISLRootTag *pRTag = NULL;
	switch(m_nScopeGlp)
	{
	case 0:
	case 1:
		pRTag = (CXISLRootTag*)m_pCurrentTag->GetRootTag();
		nRet = pRTag->m_pDocumentVar->RegistVar(pVar);
		break;
	case 2:
		pDTag = (CXISLDialogTag*)m_pCurrentTag->GetParentDialogTag();
		nRet = pDTag->m_pDialogVar->RegistVar(pVar);
		break;
	case 3:
		nRet = ((CXISLExcItem*)m_pCurrentTag)->m_pLocalVar->RegistVar(pVar);
		break;
	default:
		ASSERT(NULL);
	}

	if(nRet != 0)
	{
		AfxMessageBox("̕ϐ͊ɓo^ς݂ł",
			MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		delete pVar;
		return;
	}

	CDialog::OnOK();
}

void CXISLVarDlg::OnButtonChange() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	int nIndex;
	POSITION pos = m_lbVar.GetFirstSelectedItemPosition();
	if(pos == NULL)
		return;
	nIndex = m_lbVar.GetNextSelectedItem(pos);
	
	_TCHAR szBuff[MAX_PATH];
	LVITEMA item;
	item.mask = LVIF_TEXT|LVIF_PARAM|LVIF_STATE;
	item.iItem = nIndex;
	item.iSubItem = 0;
    item.pszText = szBuff;
    item.cchTextMax = sizeof(szBuff);
	item.stateMask = 0xFFFF;
	m_lbVar.GetItem(&item);

	CXISLVar *pVar = (CXISLVar*)item.lParam;
	CXISLChangeVarDlg CVarDlg(pVar);
	if(CVarDlg.DoModal() != IDOK)
		return;
}
